/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class WorldTransmuteAction
implements IUndoableAction {
    protected final BlockState input;
    protected final BlockState output;
    @Nullable
    protected final BlockState sneakOutput;

    private WorldTransmuteAction(BlockState input, BlockState output, @Nullable BlockState sneakOutput) {
        this.input = input;
        this.output = output;
        this.sneakOutput = sneakOutput;
    }

    protected void apply(boolean add) {
        if (add) {
            WorldTransmutations.register(this.input, this.output, this.sneakOutput);
        } else {
            WorldTransmutations.getWorldTransmutations().removeIf(entry -> entry.origin() == this.input && entry.result() == this.output && entry.altResult() == this.sneakOutput);
        }
    }

    public static class RemoveAll
    implements IUndoableAction {
        public void apply() {
            WorldTransmutations.getWorldTransmutations().clear();
        }

        public String describe() {
            return "Removing all world transmutation recipes";
        }

        public void undo() {
            WorldTransmutations.resetWorldTransmutations();
        }

        public String describeUndo() {
            return "Restored world transmutation recipes to default";
        }
    }

    public static class Remove
    extends WorldTransmuteAction {
        public Remove(BlockState input, BlockState output, @Nullable BlockState sneakOutput) {
            super(input, output, sneakOutput);
        }

        public void apply() {
            this.apply(false);
        }

        public String describe() {
            if (this.sneakOutput == null) {
                return "Removing world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output);
            }
            return "Removing world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output) + " and secondary output: " + ExpandBlockState.getCommandString((BlockState)this.sneakOutput);
        }

        public void undo() {
            this.apply(true);
        }

        public String describeUndo() {
            if (this.sneakOutput == null) {
                return "Undoing removal of world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output);
            }
            return "Undoing removal of world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output) + " and secondary output: " + ExpandBlockState.getCommandString((BlockState)this.sneakOutput);
        }
    }

    public static class Add
    extends WorldTransmuteAction {
        public Add(BlockState input, BlockState output, @Nullable BlockState sneakOutput) {
            super(input, output, sneakOutput);
        }

        public void apply() {
            this.apply(true);
        }

        public String describe() {
            if (this.sneakOutput == null) {
                return "Adding world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output);
            }
            return "Adding world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output) + " and secondary output: " + ExpandBlockState.getCommandString((BlockState)this.sneakOutput);
        }

        public void undo() {
            this.apply(false);
        }

        public String describeUndo() {
            if (this.sneakOutput == null) {
                return "Undoing addition of world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output);
            }
            return "Undoing addition of world transmutation recipe for: " + ExpandBlockState.getCommandString((BlockState)this.input) + " with output: " + ExpandBlockState.getCommandString((BlockState)this.output) + " and secondary output: " + ExpandBlockState.getCommandString((BlockState)this.sneakOutput);
        }
    }
}

